// @name "Seekbar (04.09.2013)"
// @author "NADIR1"

var tf_len = "[%length%]";
var tf_elap = "[%playback_time%]";
var tf_remain = "['-'%playback_time_remaining%]";

var g_len = "0:00";
var g_elap = "0:00";
var g_remain = g_len;

var time_y;
var time_w;
var time_h;

var g_seekbar = null;
var seekbar_y, seekbar_x, seekbar_w, seekbar_h;

seekbar = function (x, y, w, h, pad_left, pad_right) {
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	this.seekstart = pad_left;
	this.seekend = pad_right;
	this.timer = false;
	this.s_timer = false;
	var seekfader,
	g_drag,
	g_drag_seek = 0;
	var hand = false;
	var btn;
	var cur_btn;
	var pos_drw_tx;
	var knob_hov = false;
	var knob_m;
	var drp_timer = false;
	var dr_pos = false;

	this.update = function (x, y, w, h, pad_left, pad_right) {
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		this.seekstart = pad_left;
		this.seekend = pad_right;

	}

	this.draw = function (gr, alpha) {
		// Draw seekbar
		if (fb.PlaybackLength > 0) {
			if (g_drag) {
				pos = g_seekbar.w * g_drag_seek;
				g_remain = g_len;
			} else {
				pos = g_seekbar.w * (fb.PlaybackTime / fb.PlaybackLength) - 1;
			}
			pos2 = g_seekbar.w * (fb.PlaybackTime / fb.PlaybackLength) - 1;
		} else {
			pos = 0;
			pos2 = 0;
		}

		col_solid = RGB(31, 31, 31);
		col_contr = g_backcolor;
		col_back = blendColors(g_textcolor, g_backcolor, 0.7);

		// stop at the end if track time is corrupted
		pos2 = pos2 < 0 ? 0 : pos2;
		gr.FillSolidRect(this.x, this.y, this.w, this.h, col_back);
		gr.FillSolidRect(this.x, this.y, pos2, this.h, col_solid);

		if (fb.IsPlaying) {
			if (knob_hov) {
				gr.FillSolidRect(this.x + pos, this.y - 3, 3, this.h + 6, col_contr);
				gr.FillSolidRect(this.x + pos - 1, this.y - 3, 3, this.h + 6, col_solid);
			} else {
				if (pos > 0)
					gr.FillSolidRect(this.x + pos, this.y, 1, this.h, col_contr);
			}
		}
		// Txt
		gr.SetTextRenderingHint(5);

		time_font = gdi.Font("Segoe UI Semibold", 11);
		time_y = this.y + 9;

		time_w = gr.CalcTextWidth("0:00:00", time_font);
		time_h = gr.CalcTextHeight("0:00:00", time_font);

		if (metadb) {
			gr.DrawString(g_elap, time_font, g_textcolor_2, this.x, time_y, time_w, time_h, lt_stringformat);
			gr.DrawString(fb.IsPlaying ? g_remain : g_len, time_font, col_back, this.x + this.w - time_w, time_y, time_w, time_h, rt_stringformat);
			gr.DrawString(pos_drw_tx, time_font, setAlpha(g_textcolor_2, dr_pos && g_drag ? 255 - seekfader : seekfader), this.x + Math.round(this.w / 2) - Math.round(time_w / 2), time_y, time_w, time_h, ct_stringformat);
		}
	}

	this.repaint = function (event) {
		switch (event) {
		case 0:
			if (knob_hov) {
				window.RepaintRect(this.x - 2, this.y - 3, this.w + 4, this.h + 6);
			} else {
				window.RepaintRect(this.x, this.y, this.w, this.h);
			}
			break;
		case 1:
			try {
				window.RepaintRect(this.x + Math.round(this.w / 2) - Math.round(time_w / 2), time_y, time_w, time_h);
			} catch (e) {}
			break;
		case 2: // Time
			window.RepaintRect(seekbar_x, time_y, time_w, time_h);
			window.RepaintRect(seekbar_x + seekbar_w - time_w, time_y, time_w + 2, time_h);
			break;
		}
	}

	this.checkstate = function (event, x, y, step) {
		this.ishover = (x > this.x && x < this.x + this.w && y > this.y - 4 && y < this.y + this.h + 8);
		this.old = this.state;
		switch (event) {
		case "down":
			// test seekbar drag
			if (this.ishover) {
				if (fb.IsPlaying && fb.PlaybackLength) {

					drp_timer && window.ClearTimeout(drp_timer);
					drp_timer = false;
					drp_timer = window.SetTimeout(function () {
							dr_pos = true;
							seekfader = 0;
							g_seekbar.repaint(1);
						}, 350);

					g_drag = true;

					drg_tx = TimeFmt(fb.PlaybackLength * g_drag_seek);
					pos_drw_tx = Format_hms(drg_tx, g_len.length);
					g_seekbar.repaint(1);
					g_seekbar.repaint(0);

					// Repaint Time
					g_seekbar.repaint(2);

				}

				g_drag_seek = (x > g_seekbar.x && x < (g_seekbar.x + g_seekbar.w)) ? ((x - g_seekbar.x) / g_seekbar.w) : (x <= g_seekbar.x) ? 0 : 1;
			}
			break;
		case "up":
			if (g_drag && dr_pos) {
				seekfader = 0;
				this.s_timer && window.ClearInterval(this.s_timer);
				this.s_timer = false;
			}

			// Seekbar
			if (g_drag) {
				g_drag_seek = (x > g_seekbar.x && x < (g_seekbar.x + g_seekbar.w)) ? ((x - g_seekbar.x) / g_seekbar.w) : (x <= g_seekbar.x) ? 0 : 1;
				fb.PlaybackTime = fb.PlaybackLength * g_drag_seek;
				g_elap = fb.TitleFormat(tf_elap).Eval(true);
				g_drag = false;

				drp_timer && window.ClearTimeout(drp_timer);
				drp_timer = false;
				dr_pos = false;
				g_seekbar.repaint(1);
				g_seekbar.repaint(2);

			} else {
				g_drag = false;

				drp_timer && window.ClearTimeout(drp_timer);
				drp_timer = false;
				dr_pos = false;
				g_seekbar.repaint(1);

			}
			//if (g_drag)
			g_seekbar.repaint(0);
			break;
		case "right":

			break;
		case "move":
			this.ishover = (x > this.x && x < this.x + this.w && y > this.y - 4 && y < this.y + g_seekbar.h + 8);
			knob_m = (x > this.x && x < this.x + this.w && y > this.y - 3 && y < this.y + this.h + 6);
			var tmp = knob_hov;
			if (g_drag) {
				g_drag_seek = (x > g_seekbar.x && x < (g_seekbar.x + g_seekbar.w)) ? ((x - g_seekbar.x) / g_seekbar.w) : (x <= g_seekbar.x) ? 0 : 1;

				// knob pos
				drg_tx = TimeFmt(fb.PlaybackLength * g_drag_seek);
				pos_drw_tx = Format_hms(drg_tx, g_len.length);
				g_seekbar.repaint(1);

				knob_hov = true;

				g_seekbar.repaint(0);
			} else if (knob_m) {
				knob_hov = true;
			} else {
				knob_hov = false;
			}

			if (knob_hov != tmp) {
				window.RepaintRect(this.x - 2, this.y - 3, this.w + 4, this.h + 6);
			}
			break;
		case "leave":
			knob_hov = false;
			break;
		case "wheel":
			if (knob_m) {
				if (step > 0) {
					fb.RunMainMenuCommand("/λ/ǰ1");
				} else {
					fb.RunMainMenuCommand("/λ/1");
				}
				g_remain = fb.TitleFormat(tf_remain).Eval(true);
				g_elap = fb.TitleFormat(tf_elap).Eval(true);
				g_seekbar.repaint(0);
				g_seekbar.repaint(2);
			}
			break;
		case "playback":
			try {
				this.repaint(0);
				this.repaint(2);
			} catch (e) {}
			break;
		case "new_track":
			g_len = fb.Titleformat(tf_len).Eval(true);
			g_elap = "0:00";
			g_remain = "-" + g_len;
			break;
		}

	}
}
